/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.mapui;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.VWSIMAnimatorTreePane;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.sim.toolkit.viewer.mapui.IVWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorMapAttribs;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorMapToolbar;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorMapWrapper;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorRouteUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowMapPane;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowScrollPane;
import filenet.sim.toolkit.viewer.mapui.resources.VWSIMResource;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWWorkflowScrollPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMAnimatorWorkflowPane
extends VWBaseWorkflowPane
implements ItemListener,
IVWPropertyChangeListener,
ChangeListener {
    private Frame m_parentFrame = null;
    private VWSessionInfo m_sessionInfo = null;
    private VWSIMAnimatorDataModel m_animatorDataModel = null;
    private Cursor m_defaultCursor = null;
    private VWStepRouteColors m_stepRouteColors = new VWStepRouteColors();
    private VWSIMAnimatorWorkflow m_workflow = null;
    private VWSIMAnimatorMap m_selectedMap = null;
    private Vector m_allMaps = null;
    private Vector m_workflowMaps = null;
    protected Vector m_changeListeners = new Vector();

    public VWSIMAnimatorWorkflowPane(Frame parentFrame, VWSIMAnimatorDataModel animatorDataModel, VWSessionInfo sessionInfo) {
        this.m_parentFrame = parentFrame;
        this.m_sessionInfo = sessionInfo;
        this.m_defaultCursor = this.getCursor();
        this.m_stepRouteColors.setFocusColor(Color.blue);
        this.m_stepRouteColors.setSelectionColor(Color.blue);
        Dimension dim = VWStringUtils.stringToDimension(VWSIMResource.s_animatorWorkflowPaneDim);
        if (dim == null) {
            dim = new Dimension(725, 425);
        }
        this.setSize(dim.width, dim.height);
        this.m_animatorDataModel = animatorDataModel;
        VWPropertyChangeNotifier.addPropertyChangeListener(this);
        this.m_workflowMaps = new Vector();
    }

    public void addNotify() {
        Object obj;
        Vector maps;
        super.addNotify();
        if (this.m_animatorDataModel != null && (maps = this.m_animatorDataModel.getAllMaps()) != null && maps.size() > 0 && (obj = maps.elementAt(0)) != null && obj instanceof VWSIMAnimatorMap) {
            this.setSelectedMap((VWSIMAnimatorMap)obj);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.m_changeListeners.addElement(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.m_changeListeners.removeElement(l);
    }

    protected void notifyChangeListeners() {
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            ((ChangeListener)this.m_changeListeners.elementAt(i)).stateChanged(new ChangeEvent(this));
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            IVWPropertyChangeSource source = (IVWPropertyChangeSource)obj;
            int type = event.getID();
        }
    }

    void notifyDisplayMap(VWSIMAnimatorMap map) {
        Object obj = null;
        this.m_selectListeners.itemStateChanged(new ItemEvent(this, 0, map, 701));
    }

    public void itemStateChanged(ItemEvent e) {
        Object obj;
        Object[] objs;
        Object source = e.getSource();
        if (source == this) {
            return;
        }
        if (e.getStateChange() != 1) {
            return;
        }
        if (source != null && source instanceof VWSIMAnimatorTreePane && (objs = ((VWSIMAnimatorTreePane)source).getSelectedObjects()) != null && objs.length > 0 && (obj = objs[0]) != null && obj instanceof VWSIMAnimatorMap) {
            Object step;
            this.setSelectedMap((VWSIMAnimatorMap)obj);
            VWBaseWorkflowMapPane mapPane = this.getActiveMapPane();
            if (mapPane != null && mapPane instanceof VWSIMAnimatorWorkflowMapPane && (step = e.getItem()) != null && step instanceof VWSIMAnimatorStep) {
                int[] steps = new int[]{((VWSIMAnimatorStep)step).getStepId()};
                ((VWSIMAnimatorWorkflowMapPane)mapPane).selectSteps(steps);
            }
        }
    }

    public void setStepStatusVisible(boolean bShow) {
        if (this.m_mapAttribs != null && this.m_mapAttribs instanceof VWSIMAnimatorMapAttribs) {
            ((VWSIMAnimatorMapAttribs)this.m_mapAttribs).setStepStatusVisible(bShow);
        }
    }

    public VWSIMAnimatorRouteUI findRoute(int routeId) {
        if (this.m_activeMapPane != null) {
            return ((VWSIMAnimatorWorkflowMapPane)this.m_activeMapPane).findRoute(routeId);
        }
        return null;
    }

    public VWSIMAnimatorRouteUI findRoute(int workClassid, int mapId, VWSIMAnimatorRoute route) {
        VWSIMAnimatorWorkflowMapPane mapPane = this.getMapPane(workClassid, mapId);
        if (mapPane != null) {
            return mapPane.findRoute(route);
        }
        return null;
    }

    public VWBaseRouteUI findRoute(VWRouteDefinition routeDefinition) {
        return super.findRoute(routeDefinition);
    }

    protected IVWSIMAnimatorStepUI findStep(int workClassId, VWSIMAnimatorStep step) {
        VWSIMAnimatorWorkflowMapPane mapPane = this.getMapPane(workClassId, step.getMapId());
        if (mapPane != null) {
            return mapPane.findStep(step);
        }
        return null;
    }

    public IVWSIMAnimatorStepUI findStep(int workClassId, int mapId, int stepId) {
        VWSIMAnimatorWorkflowMapPane mapPane = this.getMapPane(workClassId, mapId);
        if (mapPane != null) {
            return mapPane.findStep(stepId);
        }
        return null;
    }

    public VWBaseStepUI findBaseStep(int workClassId, int mapId, int stepId) {
        VWSIMAnimatorStep stepData;
        IVWSIMAnimatorStepUI step = this.findStep(workClassId, mapId, stepId);
        if (step != null && (stepData = step.getStepData()) != null) {
            return this.findStep(stepData.getStepDefinition());
        }
        return null;
    }

    public VWBaseStepUI findStep(VWStepDefinition stepDefinition) {
        return super.findStep(stepDefinition);
    }

    public VWSIMAnimatorWorkflowMapPane getMapPane(int workClassId, String mapId) {
        if (mapId != null) {
            try {
                int id = Integer.parseInt(mapId);
                return this.getMapPane(workClassId, id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public VWSIMAnimatorWorkflowMapPane getMapPane(int workClassId, int mapId) {
        if (this.m_workflowMaps != null) {
            for (int i = 0; i < this.m_workflowMaps.size(); ++i) {
                VWSIMAnimatorMapWrapper map;
                Object obj = this.m_workflowMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMapWrapper) || (map = (VWSIMAnimatorMapWrapper)obj).getWorkClassId() != workClassId || map.getMapId() != mapId) continue;
                return (VWSIMAnimatorWorkflowMapPane)map.getMapPane();
            }
        }
        return null;
    }

    Frame getParentFrame() {
        return this.m_parentFrame;
    }

    VWStepRouteColors getStepRouteColors() {
        return this.m_stepRouteColors;
    }

    public void initialize() {
        this.setWorkflowDefinition();
    }

    protected void initMapToolbar() {
        if (this.m_mapToolbar != null) {
            this.m_mapToolbar.init();
        }
    }

    protected VWBaseWorkflowMapPane newMapPane() {
        VWSIMAnimatorWorkflowMapPane mapPane = new VWSIMAnimatorWorkflowMapPane(this);
        return mapPane;
    }

    protected VWBaseMapToolbar newMapToolbar() {
        if (this.m_mapToolbar != null) {
            return this.m_mapToolbar;
        }
        return new VWSIMAnimatorMapToolbar(this);
    }

    protected VWWorkflowScrollPane newScrollPane() {
        return new VWSIMAnimatorWorkflowScrollPane();
    }

    protected VWMapAttribs newMapAttributes() {
        if (this.m_mapAttribs == null) {
            this.m_mapAttribs = new VWSIMAnimatorMapAttribs(this);
        }
        return this.m_mapAttribs;
    }

    protected void scrollSelectionToVisible() {
        Object[] selection = this.getSelectedObjects();
        if (selection != null) {
            VWBaseWorkflowMapPane activeMapPane = this.getActiveMapPane();
            Rectangle rect = null;
            for (int i = 0; i < selection.length; ++i) {
                JComponent route;
                Object obj = selection[i];
                Rectangle r = null;
                if (obj instanceof VWRouteDefinition) {
                    route = this.findRoute((VWRouteDefinition)obj);
                    if (route != null) {
                        r = ((VWBaseRouteUI)route).getBounds();
                    }
                } else if (obj instanceof VWStepDefinition) {
                    route = this.findStep((VWStepDefinition)obj);
                    if (route != null) {
                        r = ((VWBaseStepUI)route).getBounds();
                    }
                } else {
                    r = null;
                }
                if (rect == null) {
                    rect = r;
                    continue;
                }
                rect.add(r);
            }
            if (rect != null) {
                activeMapPane.scrollRectToVisible(rect);
            }
        }
    }

    protected void setActiveMapPane(VWBaseWorkflowMapPane mapPane) {
        if (mapPane != null && mapPane instanceof VWSIMAnimatorWorkflowMapPane && this.m_animatorDataModel != null) {
            VWSIMAnimatorWorkflowMapPane animatorMapPane = (VWSIMAnimatorWorkflowMapPane)mapPane;
            this.m_selectedMap = animatorMapPane != null ? animatorMapPane.getMapData() : null;
        }
        super.setActiveMapPane(mapPane);
    }

    public boolean isActiveMapPane(VWSIMAnimatorWorkflowMapPane mapPane) {
        return this.m_activeMapPane == mapPane;
    }

    public void setWorkflowDefinition() {
        this.m_scrollPane.getViewport().removeAll();
        this.m_workflowMaps.removeAllElements();
        this.m_activeMapPane = null;
        if (this.m_animatorDataModel == null) {
            return;
        }
        try {
            VWSIMAnimatorMap map = null;
            VWSIMAnimatorMap firstMap = null;
            this.m_allMaps = this.m_animatorDataModel.getAllMaps();
            for (int i = 0; i < this.m_allMaps.size(); ++i) {
                Object obj = this.m_allMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                map = (VWSIMAnimatorMap)obj;
                if (i == 0) {
                    firstMap = map;
                }
                String mapName = map.getMapDefinition().getName();
                VWSIMAnimatorMapWrapper mapWrapper = new VWSIMAnimatorMapWrapper((VWBaseWorkflowPane)this, (VWSIMAnimatorMap)obj);
                this.m_workflowMaps.add(mapWrapper);
            }
            this.m_mapToolbar.setVisible(false);
            if (firstMap != null) {
                this.setSelectedMap(firstMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelectedMap(VWSIMAnimatorMap selectedMap) {
        this.m_selectedMap = selectedMap;
        if (this.m_workflowMaps != null) {
            Object obj = null;
            for (int i = 0; i < this.m_workflowMaps.size(); ++i) {
                obj = this.m_workflowMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMapWrapper) || selectedMap != ((VWSIMAnimatorMapWrapper)obj).getAnimatorMap()) continue;
                boolean bMapPaneAlreadyExists = ((VWSIMAnimatorMapWrapper)obj).isMapPaneAvailable();
                VWBaseWorkflowMapPane mapPane = ((VWSIMAnimatorMapWrapper)obj).getMapPane();
                this.setActiveMapPane(mapPane);
                if (bMapPaneAlreadyExists) continue;
                mapPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        }
    }

    public Vector getWorkflowMaps() {
        return this.m_workflowMaps;
    }

    public VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }

    public void releaseResources() {
        VWPropertyChangeNotifier.removePropertyChangeListener(this);
        this.m_parentFrame = null;
        this.m_sessionInfo = null;
        this.m_animatorDataModel = null;
        this.m_defaultCursor = null;
        this.m_stepRouteColors = null;
        this.m_workflow = null;
        this.m_selectedMap = null;
        if (this.m_allMaps != null) {
            Object obj = null;
            for (int i = 0; i < this.m_allMaps.size(); ++i) {
                obj = this.m_allMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMapWrapper)) continue;
                ((VWSIMAnimatorMapWrapper)obj).removeReferences();
            }
            this.m_allMaps.removeAllElements();
            this.m_allMaps = null;
        }
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeAllElements();
            this.m_changeListeners = null;
        }
        if (this.m_mapToolbar != null) {
            this.m_mapToolbar.removeReferences();
            this.m_mapToolbar = null;
        }
        super.removeReferences();
    }
}

